/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jack 3/24/2008  ADD_V8_SEPARATE_HEKA_FILES_STR_MEMBER						*
 * Jack 3/24/2008  ADD_V8_SEPARATE_HEKA_FILES_MEMBER_FUNCTIONS					*
 * 																				*
 *------------------------------------------------------------------------------*/
 
 
#include "file_utils.h"

#define HEKA_MODE_SINGLE_BOOK	0
#define HEKA_MODE_MULTI_BOOK	1

#define HEKA_NUM_ITEM 12

#define STR_HEKA_VER	"HEKAVER"
#define STR_HEKA_OFFSET "HEKAOFFSET"
#define STR_HEKA_SIZE "HEKASIZE"
#define STR_HEKA_TYPE "HEKATYPE"
#define STR_HEKA_FORMAT "HEKAFORMAT"
#define STR_HEKA_SCALER "HEKASCALER"
#define STR_HEKA_SCALER2 "HEKASCALER2"
#define STR_HEKA_ST "HEKAST"
#define STR_HEKA_LC "HEKALC"
#define STR_HEKA_LT "HEKALT"
#define STR_HEKA_ZERO "HEKAZERO"
#define STR_HEKA_XS "HEKAXS"
#define STR_HEKA_XI "HEKAXI"
#define STR_HEKA_XU "HEKAXU"
#define STR_HEKA_UNIT "HEKAUNIT"
#define STR_HEKA_UNIT2 "HEKAUNIT2"
#define STR_HEKA_BASE "HEKABASE"

#define STR_HEKA_STIMCOUNT "HEKASTIMCOUNT"
/// Hong 02/10/10 QA80-15094 HEKA_SUPPORT_BIGENDIAN_FILE_CREATED_IN_MAC
#define STR_HEKA_PUL_NEED_REVERSE "PULREVERSEORDER"
/// end HEKA_SUPPORT_BIGENDIAN_FILE_CREATED_IN_MAC


#define HEKA_IMP_LEAK 1
#define HEKA_SUB_LEAK 2
#define HEKA_SUB_ZERO 4
#define HEKA_SHOW_X	  8
#define HEKA_MB_SPARKLINE	16

#define HEKA_MAGICNUMBER	1416783205
#define HEKA_SWAPMAGICNUMBER 1701147220
#define HEKA_BUN_DAT2 844382532
#define HEKA_BUN_SWAPDAT2 1145132082

enum{
	HEKA_PARAM_ROOT_V8 = 200,
	HEKA_PARAM_GROUP_V8,
	HEKA_PARAM_SERIES_V8,
	HEKA_PARAM_SWEEP_V8,
	HEKA_PARAM_ROOT_V9,
	HEKA_PARAM_GROUP_V9,
	HEKA_PARAM_SERIES_V9,
	HEKA_PARAM_SWEEP_V9,
	HEKA_PARAM_TRACE_V9,
};


typedef struct PulRootRecord8
{
    short Version;
    char VersionName[14];
    char FileName[14];
    char Comments[400];
    double StartTime;
} PulRootRecord8;


/* 
* RootRecord        = RECORD 
*
* NOTE: The "Version" field must be at offset zero in the file
*	     while the "Mark" field must be at offset zero in RAM!
*/
typedef struct PulRootRecord9{
	int RoVersion;            //=   0; (* INT32 *)
	int RoMark;               //=   4; (* INT32 *)
	char RoVersionName[32];   //=   8; (* String32Type *)
	char RoAuxFileName[80];   //=  40; (* String80Type *)
	char RoRootText[400];     //= 120; (* String400Type *)
	double RoStartTime;       //= 520; (* LONGREAL *)
	int RoMaxSamples;         //= 528; (* INT32 *)
	int RoCRC;                //= 532; (* CARD32 *)
	short RoFeatures;         //= 536; (* SET16 *)
	short RoFiller1;          //= 538; (* INT16 *)
	int RoFiller2;            //= 540; (* INT32 *)
}PulRootRecord9;
// RootRecSize = 544 = 68 * 8


string _get_file_name_heka(string strPath)
{
	int nPos;
	nPos = strPath.ReverseFind('\\');
	
	if(nPos < 0) return "";

	return strPath.Mid(nPos+1, strlen(strPath)-nPos-1);
}

class HekaFile : public BinFile{
	public:
		HekaFile(LPCSTR lpcszFileName);
		~HekaFile(){
			Close();
		}
		int Open();
		int Import(DWORD dwOption, TreeNode &tr, int nMode=HEKA_MODE_SINGLE_BOOK);
		int ImportV9(DWORD dwOption, TreeNode &tr);
		int ImportV9_ex(DWORD dwOption, TreeNode &tr);
		int ImportV8(DWORD dwOption, TreeNode &tr);
		int ImportV8_ex(DWORD dwOption, TreeNode &tr);
        int ImportTraceV9(DWORD dwCtrl, string strName, TreeNode &trTrace, Worksheet &wks, int &nSheet, int &nCol, int &nAddX);
		int ImportTraceV8(DWORD dwCtrl, string strName, TreeNode &trSweep, Worksheet &wks, int &nSheet, int &nCol, int &nAddX);
		int ReadHeader(TreeNode& trPul, TreeNode& trPgf);
		// Jack 3/24/2008  ADD_V8_SEPARATE_HEKA_FILES_MEMBER_FUNCTIONS	
		HekaFile(LPCSTR lpcszDatFileName, LPCSTR lpcszPulFileName, LPCSTR lpcszStimuFileName);
		int OpenPulseFile(short nVer);
		int OpenStimuFile(short nVer);
		int OpenDatFile();
		int Open(string, string, string, short nVer=-1);
		short GetVersion(){return m_ver;}
		// End ADD_V8_SEPARATE_HEKA_FILES_MEMBER_FUNCTIONS	
		int GetStimuInfoV8(); // Jack 3/25/2008 ADD_GET_STIMULATION_INFO 
	private:
		Tree m_trPul;
		Tree m_trStim; // Jack 3/25/2008 ADD_STIMULATION_INFO_TREE
		// Jack 3/24/2008  ADD_V8_SEPARATE_HEKA_FILES_STR_MEMBER
		string m_strDatFileName;
		string m_strPulseFileName;
		string m_strStimuFileName;
		vector m_dStart, m_dSampleInterval;
		vector<string> m_strYUnit, m_strYUnit2;
		vector<int> m_nLeakCount;
		int m_ver;
		// End ADD_V8_SEPARATE_HEKA_FILES_STR_MEMBER

		
};

